proc()=XCSfdaMeanVar()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       grfd, createfdbasis, data2fd
; ---------------------------------------------------------------------
; Macro          XCSfdaMeanVar
; ---------------------------------------------------------------------
; Description    calculates a mean and variance function for temperature dataset using Fourier series basis
; ---------------------------------------------------------------------
; Usage          XCSfdaMeanVar() 
; ---------------------------------------------------------------------
; Author         Michal Benko 040831
; ---------------------------------------------------------------------
 y = read ("dailtemp.dat")
 tvec=#(1:365)/365
 fdb = createfdbasis ("fourier", #(0,1),31,1)
 fdtempf31=data2fd(y,tvec,fdb)

 fdameanf=fdamean(fdtempf31)
 bm=grfd(fdameanf,grid(0,1/50,50),0,4)
 bv=grfdavar(fdtempf31,grid(0,1/50,50))

axeson()
s=getsize()
setsize(500,250)
dispmeanvar=createdisplay(1,2)
show (dispmeanvar, 1, 1,bm)
show (dispmeanvar, 1, 2,bv)              
setgopt(dispmeanvar,1,1,"title","Mean Function","xvalue",0|1,"yvalue",0|1,"border",0)
setgopt(dispmeanvar,1,2,"title","Variance Function","xvalue",0|1,"yvalue",0|1,"border",0)
setsize(s[1],s[2])
endp
library("graphic")
library("fda")
XCSfdaMeanVar()

