proc()=XCSfdaTempPCAsc()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       fdaspca, grfd, createfdbasis, data2fd
; ---------------------------------------------------------------------
; Macro          XCSfdaTempPCAsc
; ---------------------------------------------------------------------
; Description     estimates and plots pc scores of the temperature functions using Fourier series basis
; ---------------------------------------------------------------------
; Usage          XCSfdaTempPCAsc() 
; ---------------------------------------------------------------------
; Author         Michal Benko 040831
; ---------------------------------------------------------------------
 y = read ("dailtemp.dat")
 tvec=#(1:365)/365
 fdb = createfdbasis ("fourier", #(0,1),31,1)
 fdtempf31=data2fd(y,tvec,fdb)
 fdapc=fdaspca(fdtempf31,0.00000,2,4)
 TempdiSC=createdisplay(1,1)
 grtempf=grfd(fdapc.fpcaresult,grid(0,1/100,100),0,#(0,1,2,3))
 sc=fdapc.scores[,1:2]
 labels=#("arv", "bag", "cal", "cha", "chu", "daw","edm", "fre", "hal", "inu", "iqa", "kam","lon", "mon", "ott", "pri", "prig", "pru","que", "reg", "res", "sch", "she", "stj","syd", "the", "thu", "tor", "ura", "van","vict", "whit", "win", "yar", "yel")
 setmaskt(sc,labels)
 setmaskp(sc,0,0,0)
 show(TempdiSC,1,1,sc)
 setgopt(TempdiSC,1,1,"title","PC scores Temperature","border",0)
endp 
  library("plot")
 library("fda")
 axeson()
XCSfdaTempPCAsc()

