proc()=XCSfdaTempSPCA()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       fdaspca, grfd, createfdbasis, data2fd
; ---------------------------------------------------------------------
; Macro          XCSfdaTempSPCA
; ---------------------------------------------------------------------
; Description     estimates and plots smoothed eigenfuction of the temperature functions using Fourier series basis
; ---------------------------------------------------------------------
; Usage          XCSfdaTempSPCA() 
; ---------------------------------------------------------------------
; Author         Michal Benko 040831
; ---------------------------------------------------------------------
 y = read ("dailtemp.dat")
 tvec=#(1:365)/365
 fdb = createfdbasis ("fourier", #(0,1),31,1)
 fdtempf31=data2fd(y,tvec,fdb)
 fdapc=fdaspca(fdtempf31,0.000001,2,4,0)
 
 Tempdi=createdisplay(1,1)
 grtempf=grfd(fdapc.fpcaresult,grid(0,1/100,100),0,#(0,1,2,3))
 show(Tempdi,1,1,grtempf)
 setgopt(Tempdi,1,1,"title","PC weight functions alpha=1e-6","border",0)
endp 
  library("plot")
 library("fda")
 axeson()
XCSfdaTempSPCA()

