proc(yhat)=cariy(bbeta,xx1,xx2,fcm1,fcm2)

yhat=matrix(dim(xx1))
fcmii=matrix(dim(xx1))

i=1
while(i<dim(xx1)+1)
yhat[i] =           (bbeta[1]+bbeta[2]*xx1[i]+bbeta[3]*xx2[i])*(fcm1[i,3]*fcm2[i,4])
yhat[i] = yhat[i] + (bbeta[4]+bbeta[5]*xx1[i]+bbeta[6]*xx2[i])*(fcm1[i,3]*fcm2[i,3])
yhat[i] = yhat[i] + (bbeta[7]+bbeta[8]*xx1[i]+bbeta[9]*xx2[i])*(fcm1[i,2]*fcm2[i,3])
yhat[i] = yhat[i] + (bbeta[10]+bbeta[11]*xx1[i]+bbeta[12]*xx2[i])*(fcm1[i,2]*fcm2[i,1])
yhat[i] = yhat[i] + (bbeta[13]+bbeta[14]*xx1[i]+bbeta[15]*xx2[i])*(fcm1[i,1]*fcm2[i,1])
yhat[i] = yhat[i] + (bbeta[16]+bbeta[17]*xx1[i]+bbeta[18]*xx2[i])*(fcm1[i,1]*fcm2[i,2])

fcmii[i]=           (fcm1[i,3]*fcm2[i,4]+fcm1[i,3]*fcm2[i,3]+fcm1[i,2]*fcm2[i,3])
fcmii[i]=fcmii[i] + (fcm1[i,2]*fcm2[i,1]+fcm1[i,1]*fcm2[i,1]+fcm1[i,1]*fcm2[i,2])

yhat[i]=yhat[i]/fcmii[i]

i=i+1
endo
endp

library("xclust")
library("stats")
z=readcsv("indo.csv")

xx1=log10(z[,3])                     ; puts the x-data into x
xx2=log10(z[,4])
yy=log10(z[,2])                     ; puts the y-data into y

xclus1=(yy~xx1)
c=3
m=2
e=0.001
alpha=0.5
fcm1=xcfcme(xclus1,c,m,e,alpha)

xclus2=(yy~xx2)
c=4
m=2
e=0.001
alpha=0.5
fcm2=xcfcme(xclus2,c,m,e,alpha)

y11=xclus1[1:49,1]   
y12=xclus1[50:54,1]
y22=xclus1[55:91,1]
y23=xclus2[92:96,1]                    
y33=xclus2[97:113,1]
y34=xclus2[114:141,1]

ab11=xclus1[1:49,2]~xclus2[1:49,2]
ab12=xclus1[50:54,2]~xclus2[50:54,2]
ab22=xclus1[55:91,2]~xclus2[55:91,2]
ab23=xclus1[92:96,2]~xclus2[92:96,2]
ab33=xclus1[97:113,2]~xclus2[97:113,2]
ab34=xclus1[114:141,2]~xclus2[114:141,2]

b11 = linreg(ab11,y11)
b12 = linreg(ab12,y12)
b22 = linreg(ab22,y22)
b23 = linreg(ab23,y23)
b33 = linreg(ab33,y33)
b34 = linreg(ab34,y34)

bbeta=b11.beta|b12.beta|b22.beta|b23.beta|b33.beta|b34.beta


;fuzzy takagi-sugeno identification
yhat=cariy(bbeta,xx1,xx2,fcm1.uu,fcm2.uu)

;least square methode
b=linreg(xx1~xx2,yy)                  
yq=b.beta[1]+b.beta[2]*xx1+b.beta[3]*xx2    

;local linear polynomial
mh = lregxestp(xx1~xx2~yy,0.5,xx1~xx2)           

;compute mean square error from these methods
mse=(yhat-yy)'*(yhat-yy)~(yq-yy)'*(yq-yy)~(mh[,3]-yy)'*(mh[,3]-yy)/dim(yy)
mse

Time = z[,1]

Y1 = Time~(yhat)
mytext1=string(" ",1:dim(Time)) 
mytext1[dim(Time)-20]="Fuzzy TS"   
Y1=setmask(Y1,"reset","line","blue","medium","text",mytext1,"over","blue")

Y2 = Time~(yy)
mytext2=string(" ",1:dim(Time)) 
mytext2[dim(Time)-30]="True Value" 
Y2=setmask(Y2,"reset","line","red","dashed","text",mytext2,"left","red")

Y3 = Time~(yq)
mytext3=string(" ",1:dim(Time))
mytext3[dim(Time)-18]="Least Square" 
Y3=setmask(Y3,"reset","line","green","thin","text",mytext3,"under","green")

Y4 = Time~(mh[,3])
mytext4=string(" ",1:dim(Time))
mytext4[dim(Time)-12]="Local Polynomial"
Y4=setmask(Y4,"reset","line","black","thin","text",mytext4,"over","black")

disp  = createdisplay(1,1)
show(disp,1,1,Y1,Y2,Y3,Y4)

title1="Indonesian Money Demand"
setgopt(disp,1,1,"title",title1,"xlabel","Time: Jan'90-Sep'01 (Monthly)","ylabel","Log(Money Demand)")

