; ----------------------------------------------------------------------
;   EBook         XCS
; ----------------------------------------------------------------------
;   See_also      XCSitt04
; ----------------------------------------------------------------------
;   Macro         XCSitt03
; ----------------------------------------------------------------------
;   Description   computes state space of an ITT with significant skew
;                 and term structure and writes down the outputs
; ----------------------------------------------------------------------
;   Usage         XCSitt03()
; ----------------------------------------------------------------------
;   Author        K. Komorad 20020401
; ----------------------------------------------------------------------
  library("finance")             ; load the libraries
  library("nummath")
  proc(fx)=t1(t)             ; the term structure function
    T=3                          ; T = time[rows(time)]
    q=0.3
    k=-q/(T+2)
    fx = sqrt(k*t+q)             ; sigma^2 is a linear function 
  endp
  proc(fder)=t1der(t)            ; first derivative of the term structure
    T=3                          ; is the same as in t1(.)
    q=0.3
    k=-q/(T+2)
    fder = k / 2 / sqrt(k*t+q)
  endp
  proc(sigma)=struct(S)          ; the skew structure function
    K=100                    ; exercise price (i.e. spot at time=0)
    sigma = (S/(3*K+S))^2
  endp

  S = 100                        ; current index level
  r = 0.1                        ; compounded riskless interest rate
  div = 0.05                     ; dividend yield
  time = 0|1|2                   ; starting time vector
  volaf = "t1"|"t1der"|"struct"

  impltree=ITT(S, r, div, time, volaf)  ; compute the ITT
  impltree                              ; show the results
