; ----------------------------------------------------------------------
;   EBook         XCS
; ----------------------------------------------------------------------
;   See_also      XCSitt05
; ----------------------------------------------------------------------
;   Macro         XCSitt04
; ----------------------------------------------------------------------
;   Description   plots state price density estimated from an ITT
; ----------------------------------------------------------------------
;   Usage         XCSitt04()
; ----------------------------------------------------------------------
;   Author        K. Komorad 20020401
; ----------------------------------------------------------------------
  library("finance")
  library("smoother")

  proc(sigma)=volafunc(S,K,time)    
    sigma=0.15 + (S-K)/10 * 0.005 
  endp

  S = 100           ; current index level
  r = 0.0625      ; compounded riskless interest rate
  div = 0.04005   ; dividend yield
  time = 0:10           ; ten years annually
  
  t=ITT(S, r, div, time, "volafunc")  ; compute the ITT  
  what=0|0|0|0|1
  plotITT(t,what,r)                   ; and plot SPD
