proc()=XCSplmhett()
; ---------------------------------------------------------------------
; EBook          XCS
; ---------------------------------------------------------------------
; See_also       XCSplmk, XCSplmls, XCSplmp, XCSplmhetmean
; ---------------------------------------------------------------------
; Macro          XCSplmhett
; ---------------------------------------------------------------------
; Description    
; ---------------------------------------------------------------------
; Usage          XCSplmhett() 
; ---------------------------------------------------------------------
; Author         Hua Liang 
; ---------------------------------------------------------------------


randomize(100)
n = 100
sig=0*matrix(3,3)
sig[,1]=#(0.81,0.1,0.2)
sig[,2]=#(0.1,2.25,0.1)
sig[,3]=#(0.2,0.1,1)
x =normal(n,3)*sig
t =sort(uniform(n))
beta0=#(1.2, 1.3, 1.4)  ; the true value
y =x*beta0+t^3+0.1*(t+5/(1+t)).*normal(n)
h =0.15
res=plmhett(x,t,y,h)
res.hbetals
res.hbeta
;;;;;;;;;;;;;;;for non-parametric part
ddpt=createdisplay(1,1)
datah1=t~t^3
datah2=t~res.hg0
datah3=t~res.hg
part=grid(1,1,rows(t))'
setmaskp(datah1,1,0,1)
setmaskp(datah2,4,0,3)
setmaskp(datah3,7,0,5)
setmaskl(datah1,part,1,1,1)
setmaskl(datah2,part,4,1,3)
setmaskl(datah3,part,2,1,1)
show(ddpt,1,1,datah1,datah2,datah3)
setgopt(ddpt,1,1,"xlabel","T","title","Simulation comparison","ylabel","g(T) and its estimate values")
endp

library("plm")
XCSplmhett()


