library ("spatial")
topo = read ("topo.dat")
;
; Figure 14.5 VR
;
myres2 = SPKRsurfls (2, topo)
mygres2 = SPKRsurfgls (2, 0, topo, 1000, 0.7, 0, 1)
;
mygrid2 = SPKRtrmat (myres2, 0, 6.5, 0, 6.5, 30)
myggrid2tr = SPKRtrmat (mygres2, 0, 6.5, 0, 6.5, 30)
myggrid2pr = SPKRprmat (mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat (mygres2, 0, 6.5, 0, 6.5, 30)
;
f = createdisplay (2, 2)
;
cont2 = SPKRmultcontours (f, 1, 1, mygrid2, 750, 975, 25)
topoxydat = topo[,1] ~ topo[,2]
setmaskp (topoxydat, 4, 5, 8)
adddata (f, 1, 1, topoxydat)
setheadline (f, 1, 1, "LS trend surface")
setgopt (f, 1, 1, "xoffset", 15|15, "yoffset", 15|15)
;
cont2tr = SPKRmultcontours (f, 1, 2, myggrid2tr, 750, 950, 25)
adddata (f, 1, 2, topoxydat)
setheadline (f, 1, 2, "GLS trend surface")
setgopt (f, 1, 2, "xoffset", 15|15, "yoffset", 15|15)
;
cont2pr = SPKRmultcontours (f, 2, 1, myggrid2pr, 700, 950, 25)
adddata (f, 2, 1, topoxydat)
setheadline (f, 2, 1, "Kriging prediction")
setgopt (f, 2, 1, "xoffset", 15|15, "yoffset", 15|15)
;
cont2se = SPKRmultcontours (f, 2, 2, myggrid2se, 20, 25, 5)
adddata (f, 2, 2, topoxydat)
setheadline (f, 2, 2, "Kriging s.e.")
setgopt (f, 2, 2, "xoffset", 15|15, "yoffset", 15|15)
