library ("spatial")
topo = read ("topo.dat")
;
; Figure 14.6 VR
;
myres2 = SPKRsurfls (2, topo)
corres = SPKRcorrelogram (myres2, 25)
;
e = createdisplay (1, 2)
setgopt (e, 1, 1, "dispsize", 750 | 300)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (e, 1, 1, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 3)
adddata (e, 1, 1, linedat2)
;
xydat = corres.xpres ~ corres.ypres
setmaskp (xydat, 4, 5, 8)
adddata (e, 1, 1, xydat)
;
ddat = grid (0, 0.1, 71)
linedat3 = ddat ~ SPKRexpcov (ddat, 0.7, 0, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (e, 1, 1, linedat3)
setheadline (e, 1, 1, "Correlogram")
setgopt (e, 1, 1, "xlabel", "Distance (r)", "ylabel", "rho(r)")
setgopt (e, 1, 1, "xoffset", 15|15, "yoffset", 15|15)
;
;
varres = SPKRvariogram (myres2, 25)
;
xydat = varres.xpres ~ varres.ypres
setmaskp (xydat, 4, 5, 8)
show (e, 1, 2, xydat)
setheadline (e, 1, 2, "Variogram")
setgopt (e, 1, 2, "xlabel", "Distance (r)", "ylabel", "gamma(r)")
setgopt (e, 1, 2, "xoffset", 15|15, "yoffset", 15|15)
