library ("spatial")
topo = read ("topo.dat")
;
; Figure 14.7 VR
;
mygres2 = SPKRsurfgls (2, 0, topo, 1000, 0.7, 0, 1)
corres = SPKRcorrelogram (mygres2, 25)
;
g = createdisplay (1, 2)
setgopt (g, 1, 1, "dispsize", 750 | 300)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (g, 1, 1, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 2)
adddata (g, 1, 1, linedat2)
;
xydat = corres.xpres ~ corres.ypres
setmaskp (xydat, 4, 5, 8)
adddata (g, 1, 1, xydat)
;
ddat = grid (0, 0.1, 71)
linedat3 = ddat ~ SPKRexpcov (ddat, 0.7, 0, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (g, 1, 1, linedat3)
;
ddat = grid (0, 0.1, 71)
linedat4 = ddat ~ SPKRgaucov (ddat, 1.0, 0.3, 1)
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:70) ~ (2:71), 3, 3, 2)
adddata (g, 1, 1, linedat4)
setheadline (g, 1, 1, "Correlogram (Fitted Data)")
setgopt (g, 1, 1, "xlabel", "Distance (r)", "ylabel", "rho(r)")
setgopt (g, 1, 1, "xoffset", 15|15, "yoffset", 15|15)
;
; (right)
;
myres2 = SPKRsurfls (0, topo)
corres = SPKRcorrelogram (myres2, 25)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (g, 1, 2, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 2)
adddata (g, 1, 2, linedat2)
;
xydat = paf (corres.xpres ~ corres.ypres, abs(corres.ypres) <= 1.1)
setmaskp (xydat, 4, 5, 8)
adddata (g, 1, 2, xydat)
;
ddat = grid (0, 0.1, 71)
linedat3 = ddat ~ SPKRgaucov (ddat, 2.0, 0.05, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (g, 1, 2, linedat3)
setheadline (g, 1, 2, "Correlogram (Raw Data)")
setgopt (g, 1, 2, "xlabel", "Distance (r)", "ylabel", "rho(r)")
setgopt (g, 1, 2, "xoffset", 15|15, "yoffset", 15|15)
