library ("spatial")
topo = read ("topo.dat")
;
; Figure 14.8 VR
;
mygres2 = SPKRsurfgls (2, 1, topo, 1000, 1, 0.3, 1)
;
myggrid2pr = SPKRprmat (mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat (mygres2, 0, 6.5, 0, 6.5, 25)
;
h = createdisplay (2, 2)
;
cont2pr = SPKRmultcontours (h, 1, 1, myggrid2pr, 725, 950, 25)
topoxydat = topo[,1] ~ topo[,2]
setmaskp (topoxydat, 4, 5, 8)
adddata (h, 1, 1, topoxydat)
setheadline (h, 1, 1, "Kriging prediction")
setgopt (h, 1, 1, "xoffset", 15|15, "yoffset", 15|15)
;
cont2se = SPKRmultcontours (h, 1, 2, myggrid2se, 20, 25, 5)
adddata (h, 1, 2, topoxydat)
setheadline (h, 1, 2, "Kriging s.e.")
setgopt (h, 1, 2, "xoffset", 15|15, "yoffset", 15|15)
;
; (bottom)
;
mygres2 = SPKRsurfgls (0, 1, topo, 10000, 2, 0.05, 1)
;
myggrid2pr = SPKRprmat (mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat (mygres2, 0, 6.5, 0, 6.5, 25)
;
cont2pr = SPKRmultcontours (h, 2, 1, myggrid2pr, 725, 925, 25)
adddata (h, 2, 1, topoxydat)
setheadline (h, 2, 1, "Kriging prediction")
setgopt (h, 2, 1, "xoffset", 15|15, "yoffset", 15|15)
;
cont2se = SPKRmultcontours (h, 2, 2, myggrid2se, 15, 25, 5)
adddata (h, 2, 2, topoxydat)
setheadline (h, 2, 2, "Kriging s.e.")
setgopt (h, 2, 2, "xoffset", 15|15, "yoffset", 15|15)
