library ("spatial")
pines = read ("pines.dat")
;
; Figure 14.9 VR
;
pinesobj = SPPPinit (pines, 0, 100, 0, 100, 10)
spkfn = SPPPkfn (pinesobj, 5, 100)
;
dd = createdisplay (3, 3)
;
; Upper left plot
;
xydat = pinesobj.pp
setmaskp (xydat, 4, 5, 8)
show (dd, 1, 1, xydat)
setheadline (dd, 1, 1, "Pines Data")
setgopt (dd, 1, 1, "xoffset", 15|15, "yoffset", 15|15)
;
; Upper plots calculations
;
SPPPinitrandom (0)
sppsim = SPPPpsim (100, 71)
spkenvl = SPPPkenvl (5, 100, sppsim)
;
; Upper center plot
;
xydat = sppsim.xmat[,1] ~ sppsim.ymat[,1]
setmaskp (xydat, 4, 5, 8)
show (dd, 1, 2, xydat)
setheadline (dd, 1, 2, "Psim (71) - 1 Run")
setgopt (dd, 1, 2, "xoffset", 15|15, "yoffset", 15|15)
;
; Upper right plot
;
linedat2 = spkenvl.hx ~ spkenvl.hl
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, (1:99) ~ (2:100), 1, 2, 2)
show (dd, 1, 3, linedat2)
;
linedat3 = spkenvl.hx ~ spkenvl.hu
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:99) ~ (2:100), 1, 2, 2)
adddata (dd, 1, 3, linedat3)
;
linedat4 = spkenvl.hx ~ spkenvl.aver
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:99) ~ (2:100), 3, 2, 2)
adddata (dd, 1, 3, linedat4)
;
linedat = spkfn.x ~ spkfn.y
setmaskp (linedat, 0, 0, 0)
setmaskl (linedat, (1:99) ~ (2:100), 0, 1, 2)
adddata (dd, 1, 3, linedat)
setheadline (dd, 1, 3, "Psim (71) - Envelopes")
setgopt (dd, 1, 3, "xlabel", "Distance (r)", "ylabel", "L(r)")
setgopt (dd, 1, 3, "xoffset", 15|15, "yoffset", 15|15)
;
; Center plots calculations
;
SPPPinitrandom (0)
spstrauss1 = SPPPstrauss (100, 71, 0.15, 0.7)
spkenvl = SPPPkenvl (1.5, 100, spstrauss1)
;
; Center left plot
;
xydat = spstrauss1.xmat[,1] ~ spstrauss1.ymat[,1]
setmaskp (xydat, 4, 5, 8)
show (dd, 2, 1, xydat)
setheadline (dd, 2, 1, "Strauss (71, 0.15, 0.7) - 1 Run")
setgopt (dd, 2, 1, "xoffset", 15|15, "yoffset", 15|15)
;
; Center center plot
;
linedat2 = spkenvl.hx ~ spkenvl.hl
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, (1:99) ~ (2:100), 1, 2, 2)
show (dd, 2, 2, linedat2)
;
linedat3 = spkenvl.hx ~ spkenvl.hu
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:99) ~ (2:100), 1, 2, 2)
adddata (dd, 2, 2, linedat3)
;
linedat4 = spkenvl.hx ~ spkenvl.aver
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:99) ~ (2:100), 3, 2, 2)
adddata (dd, 2, 2, linedat4)
;
linedat = paf(spkfn.x ~ spkfn.y, spkfn.x <= 1.5)
setmaskp (linedat, 0, 0, 0)
setmaskl (linedat, (1:29) ~ (2:30), 0, 1, 2)
adddata (dd, 2, 2, linedat)
setheadline (dd, 2, 2, "Strauss (71, 0.15, 0.7) - Envelopes")
setgopt (dd, 2, 2, "xlabel", "Distance (r)", "ylabel", "L(r)")
setgopt (dd, 2, 2, "xoffset", 15|15, "yoffset", 15|15)
;
; Center right plot
;
spstrauss2 = SPPPstrauss (100, 71, 0.2, 0.7)
spkenvl = SPPPkenvl (1.5, 100, spstrauss2)
;
linedat2 = spkenvl.hx ~ spkenvl.hl
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, (1:99) ~ (2:100), 1, 2, 2)
show (dd, 2, 3, linedat2)
;
linedat3 = spkenvl.hx ~ spkenvl.hu
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:99) ~ (2:100), 1, 2, 2)
adddata (dd, 2, 3, linedat3)
;
linedat4 = spkenvl.hx ~ spkenvl.aver
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:99) ~ (2:100), 3, 2, 2)
adddata (dd, 2, 3, linedat4)
;
linedat = paf(spkfn.x ~ spkfn.y, spkfn.x <= 1.5)
setmaskp (linedat, 0, 0, 0)
setmaskl (linedat, (1:29) ~ (2:30), 0, 1, 2)
adddata (dd, 2, 3, linedat)
setheadline (dd, 2, 3, "Strauss (71, 0.2, 0.7) - Envelopes")
setgopt (dd, 2, 3, "xlabel", "Distance (r)", "ylabel", "L(r)")
setgopt (dd, 2, 3, "xoffset", 15|15, "yoffset", 15|15)
;
; Lower plots calculations
;
SPPPinitrandom (0)
spssi = SPPPssi (100, 71, 0.7)
spkenvl1 = SPPPkenvl (1.5, 100, spssi)
spkenvl2 = SPPPkenvl (5, 100, spssi)
;
; Lower left plot
;
xydat = spssi.xmat[,1] ~ spssi.ymat[,1]
setmaskp (xydat, 4, 5, 8)
show (dd, 3, 1, xydat)
setheadline (dd, 3, 1, "SSI (71, 0.7) - 1 Run")
setgopt (dd, 3, 1, "xoffset", 15|15, "yoffset", 15|15)
;
; Lower center plot
;
linedat2 = spkenvl1.hx ~ spkenvl1.hl
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, (1:99) ~ (2:100), 1, 2, 2)
show (dd, 3, 2, linedat2)
;
linedat3 = spkenvl1.hx ~ spkenvl1.hu
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:99) ~ (2:100), 1, 2, 2)
adddata (dd, 3, 2, linedat3)
;
linedat4 = spkenvl1.hx ~ spkenvl1.aver
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:99) ~ (2:100), 3, 2, 2)
adddata (dd, 3, 2, linedat4)
;
linedat = paf(spkfn.x ~ spkfn.y, spkfn.x <= 1.5)
setmaskp (linedat, 0, 0, 0)
setmaskl (linedat, (1:29) ~ (2:30), 0, 1, 2)
adddata (dd, 3, 2, linedat)
setheadline (dd, 3, 2, "SSI (71, 0.7) - Envelopes")
setgopt (dd, 3, 2, "xlabel", "Distance (r)", "ylabel", "L(r)")
setgopt (dd, 3, 2, "xoffset", 15|15, "yoffset", 15|15)
;
; Lower right plot
;
linedat2 = spkenvl2.hx ~ spkenvl2.hl
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, (1:99) ~ (2:100), 1, 2, 2)
show (dd, 3, 3, linedat2)
;
linedat3 = spkenvl2.hx ~ spkenvl2.hu
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:99) ~ (2:100), 1, 2, 2)
adddata (dd, 3, 3, linedat3)
;
linedat4 = spkenvl2.hx ~ spkenvl2.aver
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:99) ~ (2:100), 3, 2, 2)
adddata (dd, 3, 3, linedat4)
;
linedat = spkfn.x ~ spkfn.y
setmaskp (linedat, 0, 0, 0)
setmaskl (linedat, (1:99) ~ (2:100), 0, 1, 2)
adddata (dd, 3, 3, linedat)
setheadline (dd, 3, 3, "SSI (71, 0.7) - Envelopes")
setgopt (dd, 3, 3, "xlabel", "Distance (r)", "ylabel", "L(r)")
setgopt (dd, 3, 3, "xoffset", 15|15, "yoffset", 15|15)
