;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      pdfstab 
;
;----------------------------------------------------------------------------
; Macro         XCSstab01
; 
;----------------------------------------------------------------------------
; Description   creates a semilog plot of symmetric stable probability density 
;               function for different alphas  
;---------------------------------------------------------------------------- 
 
;library(????) pdfstab
library("plot")
x = (-30:30)/5 
n=1000
alpha = #(2,1.8,1.5,1)
w = pdfstab(x,alpha[1],1,0,0,n)
s1 = setmask(x~log(w),"line","black","thin","solid")

x = (-50:50)/5 
w = pdfstab(x,alpha[2],1,0,0,n)
s2 = setmask(x~log(w),"line","red","medium","solid")
w = pdfstab(x,alpha[3],1,0,0,n)
s3 = setmask(x~log(w),"line","blue","thin","dashed")
w = pdfstab(x,alpha[4],1,0,0,n)
s4 = setmask(x~log(w),"line","green","medium","dashed")
XCSstab01 = createdisplay(1,1)
show(XCSstab01,1,1,s1,s2,s3,s4)
setgopt(XCSstab01,1,1, "title", "Dependence on alpha ")
setgopt(XCSstab01,1,1, "xlabel", "x", "ylabel", "log(PDF(x))") 
setgopt(XCSstab01,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab01,1,1, "border", 0) 

