;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      pdfstab 
;
;----------------------------------------------------------------------------
; Macro         XCSstab02
; 
;----------------------------------------------------------------------------
; Description   creates a plot of stable probability density  function for 
;               different betas  
;      
;---------------------------------------------------------------------------- 

;library(????)pdfstab
library("plot")
x = (-50:50)/10 
n=1000
alpha = 1.2
beta = #(0,0.5,0.8,1)
w = pdfstab(x,alpha,1,beta[1],0,n)
s1 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha,1,beta[2],0,n)
s2 = setmask(x~w,"line","red","medium","solid")
w = pdfstab(x,alpha,1,beta[3],0,n)
s3 = setmask(x~w,"line","blue","thin","dashed")
w = pdfstab(x,alpha,1,beta[4],0,n)
s4 = setmask(x~w,"line","green","medium","dashed")
XCSstab02 = createdisplay(1,1)
show(XCSstab02,1,1,s1,s2,s3,s4)
setgopt(XCSstab02,1,1, "title", "Dependence on beta ")
setgopt(XCSstab02,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(XCSstab02,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab02,1,1, "border", 0) 

