;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      pdfstab, pdfcauch, pdflevy 
;
;----------------------------------------------------------------------------
; Macro         XCSstab03
; 
;----------------------------------------------------------------------------
; Description   plot of probability density functions of  
;               Gaussian, Cauchy and Levy distributions   
;---------------------------------------------------------------------------- 

;library(????) pdfcauch pdflevy
library("plot")
x = (-50:50)/10
n = pdfn(x)
s1 = setmask(x~n,"line","black","thin","solid")
c = pdfcauch(x,1,0)
s2 = setmask(x~c,"line","red","medium","solid")
l = pdflevy(x,1,0)
s3 = setmask(x~l,"line","blue","thin","dashed")
XCSstab03 = createdisplay(1,1)
show(XCSstab03,1,1,s1,s2,s3)
setgopt(XCSstab03,1,1, "title", "Gaussian, Cauchy and Levy distributions")
setgopt(XCSstab03,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(XCSstab03,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab03,1,1, "border", 0) 

