;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      pdfstab
;
;----------------------------------------------------------------------------
; Macro         XCSstab04
; 
;----------------------------------------------------------------------------
; Description   comparison of S and S0 parameterizations
; 
;---------------------------------------------------------------------------- 

;library(??????) pdfstab
library("plot")
x = (-50:50)/10
alpha = #(0.5,0.75,1,1.25,1.5)
beta =  0.5
n = 1000

; S parametrization
mu = 0*alpha

w = pdfstab(x,alpha[1],1,beta,mu[1],n)
s1 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha[2],1,beta,mu[2],n)
s2 = setmask(x~w,"line","red","medium","solid")
w = pdfstab(x,alpha[3],1,beta,mu[3],n)
s3 = setmask(x~w,"line","blue","thin","dashed")
w = pdfstab(x,alpha[4],1,beta,mu[4],n)
s4 = setmask(x~w,"line","green","medium","dashed")
w = pdfstab(x,alpha[5],1,beta,mu[5],n)
s5 = setmask(x~w,"line","cyan","thin","solid")

; S0 parametrization
mu = -beta*tan(0.5*pi.*alpha) 
mu[3] = 0

w = pdfstab(x,alpha[1],1,beta,mu[1],n)
s01 = setmask(x~w,"line","black","thin","solid")
w = pdfstab(x,alpha[2],1,beta,mu[2],n)
s02 = setmask(x~w,"line","red","medium","solid")
w = pdfstab(x,alpha[3],1,beta,mu[3],n)
s03 = setmask(x~w,"line","blue","thin","dashed")
w = pdfstab(x,alpha[4],1,beta,mu[4],n)
s04 = setmask(x~w,"line","green","medium","dashed")
w = pdfstab(x,alpha[5],1,beta,mu[5],n)
s05 = setmask(x~w,"line","cyan","thin","solid")

XCSstab04 = createdisplay(1,2)
show(XCSstab04,1,1,s1,s2,s3,s4,s5)
show(XCSstab04,1,2,s01,s02,s03,s04,s05)
setgopt(XCSstab04,1,1, "title", "S parameterization")
setgopt(XCSstab04,1,1, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(XCSstab04,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab04,1,2, "title", "S0 parameterization")
setgopt(XCSstab04,1,2, "xlabel", "x", "ylabel", "PDF(x)") 
setgopt(XCSstab04,1,2, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab04,1,1, "border", 0) 
setgopt(XCSstab04,1,2, "border", 0) 

