;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      cdfstab
;
;----------------------------------------------------------------------------
; Macro         XCSstab05
; 
;----------------------------------------------------------------------------
; Description   a double logarithmic plot of right tails of symmetric stable
;               disribution functions for different alphas 
;---------------------------------------------------------------------------- 
;library(??????) cdfstab
library("plot")

alpha = #(2,1.95,1.8,1.5)

x1 = (5:60)/10
x2 = (1:200)/20 + 60/10 
x = x1|x2
w = cdfstab(x1,alpha[1],1,0,0,1000)
s1= x1~(1-w)
s1 = setmask(log(s1),"line","black","thin","solid")

w = cdfstab(x,alpha[2],1,0,0,7000)
s2= x~(1-w)
s2 = setmask(log(s2),"line","red","medium","solid")

w = cdfstab(x,alpha[3],1,0,0,2000)
s3= x~(1-w)
s3 = setmask(log(s3),"line","blue","thin","dashed")

w = cdfstab(x,alpha[4],1,0,0,2000)
s4= x~(1-w)
s4 = setmask(log(s4),"line","green","medium","dashed")

XCSstab05 = createdisplay(1,1)
show(XCSstab05,1,1,s1,s2,s3,s4)
setgopt(XCSstab05,1,1, "title", "Tails of stable laws")
setgopt(XCSstab05,1,1, "xlabel", "log(x)", "ylabel", "log(1-CDF(x))") 
setgopt(XCSstab05,1,1, "border", 0) 

