;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      rndsstab, rndstab, hillgp1diag 
;
;----------------------------------------------------------------------------
; Macro         XCSstab07
; 
;----------------------------------------------------------------------------
; Description   plots of the Hill statistics of stable samples 
; 
;---------------------------------------------------------------------------- 

;library(??????) rndsstab
library("plot")
library("finance")

randomize(10)
alpha = 1.8
N = 10^6
x=rndsstab(alpha,1,N)
k = 40:2000
r=hillgp1diag(x,k)
z6=k~r
z6=setmask(z6,"line","blue")
a6=k~(k*0+alpha)
a6=setmask(a6,"line","red","thick")

k = k|(11:1000)*100
r=hillgp1diag(x,k)
z61=k~r
z61=setmask(z61,"line","blue")
a61=k~(k*0+alpha)
a61=setmask(a61,"line","red","thick")

N = 10^4
x=rndsstab(alpha,1,N)
k = 40:1000
r=hillgp1diag(x,k)
z4=k~r
z4=setmask(z4,"line","blue")
a4=k~(k*0+alpha)
a4=setmask(a4,"line","red","thick")

XCSstab07 = createdisplay(1,3)
show(XCSstab07,1,1,z4,a4)
show(XCSstab07,1,2,z61,a61)
show(XCSstab07,1,3,z6,a6)
setgopt(XCSstab07,1,1, "title", "10^4 samples")
setgopt(XCSstab07,1,1, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(XCSstab07,1,1, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab07,1,2, "title", "10^6 samples")
setgopt(XCSstab07,1,2, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(XCSstab07,1,2, "xvalue", 0|1, "yvalue", 0|1) 
setgopt(XCSstab07,1,3, "title", " 10^6 samples")
setgopt(XCSstab07,1,3, "xlabel", "Order statistics", "ylabel", "alpha") 
setgopt(XCSstab07,1,3, "xvalue", 0|1, "yvalue", 0|1,"xmajor",1000) 
setgopt(XCSstab07,1,1, "border", 0)
setgopt(XCSstab07,1,2, "border", 0)
setgopt(XCSstab07,1,3, "border", 0)

