;----------------------------------------------------------------------------
; EBook         XCS
; 
;----------------------------------------------------------------------------
; See_also      cdfstab, pdfstab, stabreg 
;
;----------------------------------------------------------------------------
; Macro         XCSstab08
; 
;----------------------------------------------------------------------------
; Description   stable and Gaussian fits to USD/GBP exchange rate returns
; 
;---------------------------------------------------------------------------- 


;library(???????) stabreg , cdfstab
x = read("GBPUSD.dat")
y = (x[2:rows(x),2] - x[1:rows(x)-1,2])./x[1:rows(x)-1,2]
y = sort(y)
n = rows(y)
F = (1:n)/n ; empirical cdf

; estymation of parameters
w = stabreg(y)
st = cdfstab(y,w.alpha,w.sigma,w.beta,w.mu,1000)

mu = mean(y)
si = sqrt(var(y))
gs = cdfn((y-mu)/si)

nad = adstat(y,gs)
sad = adstat(y,st)
nk  = kstat(y,gs)
sk  = kstat(y,st)

out1  = "                 Stable fit               "
out2  = "Parameters                                "
out3  = "alpha            "+string("%1.4f",w.alpha )+ "                   " 
out4  = "sigma            "+string("%1.4f",w.sigma )+ "                   " 
out5  = "beta             "+string("%1.4f",w.beta )+ "                  " 
out6  = "mu               "+string("%1.4f",w.mu )+ "                   " 
out7  = "                 p-value   test value     " 
out8  = "Anderson-Darling "+string("%1.4f",sad.pv) +"      " + string("%4.4f",sad.cval)+ "       " 
out9  = "Kolmogorov       "+string("%1.4f",sk.pv) +"      " + string("%4.4f",sk.cval)  + "       "
out10 = "                                          " 
out11 = "                 Gaussian fit             "
out12 = "                 p-value   test value     " 
out13 = "Parameters                                "
out14 = "mean             "+string("%1.4f",mu )+ "                   " 
out15 = "std              "+string("%1.4f",si )+ "                   " 
out16 = "Anderson-Darling "+string("%1.4f",nad.pv) +"      " + string("%4.4f",nad.cval)+ "      " 
out17 = "Kolmogorov       "+string("%1.4f",nk.pv) +"      " +string("%4.4f",nk.cval)   + "       "
output = out1|out2|out3|out4|out5|out6|out7|out8|out9
output =output|out10|out11|out12|out13|out14|out15|out16|out17
output

