; -----------------------------------------------------------------             

                                                       

; -----------------------------------------------------------------             

;  See_also     XLGkernelhazard2, XLGempiricalfunction                                                               

; -----------------------------------------------------------------

;   Macro        XLGkernelhazard

; -----------------------------------------------------------------

;   Description  hazard density estimation of earthquake data, using

;		empiric and kernel distribution function estimation 

;		(by exact computation 

;                on a grid of 100 points). Epanechnikov kernel is used.

;		You can choose the bandwith as the cross-validation

;		bandwidth selected for density estimation: Quantlet 

;		denbwsel (with epanechnikov kernel)

; -----------------------------------------------------------------







library("smoother")

library("plot")

library("hazard")

 

x=read("terremotos")

            



p=100

tmin=min(x)

tmax=max(x)

s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

h=(tmax-tmin)/50

	

rn=kernelempirichazard(x,h,s) ; 

rh=kernelhazard(x,h,s)



z1= setmask(s~rh,"line","red")

z2= setmask(s~rn,"line","green")

plot(z1,z2)

tl="hazard function estimation"

xl="delta ti  "

yl="estimations  "

setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)



