                                                     

; -----------------------------------------------------------------             

;  See_also     XLGkernelhazard                                                                

; -----------------------------------------------------------------

;   Macro        XLGkernelhazard2

; -----------------------------------------------------------------

;   Description  hazard density estimation of normal standard data, using

;		empiric and kernel distribution function estimation

;		(by exact computation 

;                on a grid of 50 points). Epanechnikov kernel is used.

;		You can choose the bandwith as the cross-validation

;		bandwidth selected for density estimation: Quantlet 

;		denbwsel (with epanechnikov kernel)

; -----------------------------------------------------------------



 	library("smoother")

	library("plot")

        library("hazard")

	 n=100

         x=normal(n)

	p=50

	tmin=-2

	tmax=2

	s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

	fdis=cdfn2(s)    ;; distribution function of a N(0,1)

	fden=pdfn2(s)	    ;; density function of a  N(0,1)

 

	 r=fden/(1-fdis)     ;;  true hazard function

	h=0.45

	 rn=kernelempirichazard(x,h,s)

	 rh=kernelhazard(x,h,s)

	z1= setmask(s~r,"line","black")

	z2= setmask(s~rn,"line","red")

	z3= setmask(s~rh,"line","blue")

	plot(z1,z2,z3)

	tl="kernel empiric hazard function estimation"

	xl="N(0,1)     "

	yl="hazard function"

	setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)



