; -----------------------------------------------------------------                                                                  

;   Macro        XLGkernelintensity

; -----------------------------------------------------------------

;   Description  Kernel intensity estimation of earthquake data. 

;		Epanechnikov kernel is used.

;		You can choose the bandwith as the cross-validation

;		bandwidth selected for density estimation: Quantlet 

;		denbwsel (with epanechnikov kernel)

; -----------------------------------------------------------------









library("smoother")

library("plot")

library("hazard")

 

x=read("terremotos")

n=rows(x)            

 

h=50                      ;bandwith of the estimator



 

p=100

tmin=min(x)		; the first point in which we calculate the estimation

tmax=max(x)		; the last point

s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

	



	

fh=denxest(x,h,"epa",s)

int=n*fh[,2]		; kernel intensity estimation

 

z1= setmask(s~int,"line","black")

plot(z1)

tl="intensity function estimation"

xl="estimation points"

yl="intensity estimation"

setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)



