proc(y)=densestim(X,xx,ker,h)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      densband

; -----------------------------------------------------------------

; Macro         densestim

; -----------------------------------------------------------------

; Description   kernel estimate of the density of random value X

; -----------------------------------------------------------------

; Usage        y = densestim(X,xx,ker,h)

;  Input

;    Parameter  X

;    Definition  n x 1 array - sample of random variable

;    Parameter  xx

;    Definition  m x 1 array - points for evalueting the density

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  h

;    Definition  scalar - bandwidth

;

;  Output

;    Parameter  y

;    Definition  m x 1 array - values of the density in xx

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           X=normal(100,1)

;           ker="optker02"

;           k = 2

;           h = densiterband(X,ker,k)

;           x = aseq(-3,0.02,301)

;           y = densestim(X,x,ker,h)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The estimation of the optimal bandwidth

;               is counted

; -----------------------------------------------------------------

; Keywords      density, kernel, bandwidth

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



n=rows(X)

m=rows(xx)

y=matrix(m,1)

j=0

while (j<m)

 j=j+1

 xp=(xx[j]-X)/h

 y[j]=sum(_ker(xp))

endo

y=y/(h*n)



endp

