proc(h)=densiterband(X,ker,k)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      HFestim HFitsteff db1step

; -----------------------------------------------------------------

; Macro         densiterband

; -----------------------------------------------------------------

; Description   estimation of optimal bandwidth for kernel density

;               estimate using iterative Steffensen method

; -----------------------------------------------------------------

; Usage        h = densiterband(X,ker,k)

;  Input

;    Parameter  X

;    Definition  n x 1 array - sample of random variable

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  k

;    Definition  scalar - order of the kernel

;

;  Output

;    Parameter  h

;    Definition  scalar - estimation of the optimal bandwidth

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           X=normal(100,1)

;           ker="optker02"

;           k = 2

;           h = densiterband(X,ker,k)

;           x = aseq(-3,0.02,301)

;           y = densestim(X,x,ker,h)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The estimation of the optimal bandwidth

;               is counted and the estimate of the density

;               is presented

; -----------------------------------------------------------------

; Keywords      density, kernel, bandwidth

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



;library("")
func("dib1step.xpl")		; added for absence of hazker library

prec=0.001

maxit=50

n=rows(X)

b=#(2.5324, 3.3175, 3.9003, 4.3949, 4.8349, 5.2361)

; constants for upper band of bandwidth

sig=sqrt(var(X))

hold=sig*b[k/2]*n^(-1/(2*k+1))



h1=dib1step(hold,X,ker,k)

h2=dib1step(h1,X,ker,k)

hnew=hold-(h1-hold)^2/(h2-2*h1+hold)

errh=abs((hnew-hold)/hnew)

ni=1

while((errh>prec) && (ni<maxit))

 hold=hnew

 h1=dib1step(hold,X,ker,k)

 h2=dib1step(h1,X,ker,k)

 hnew=hold-(h1-hold)^2/(h2-2*h1+hold)

 errh=abs((hnew-hold)/hnew)

 ni=ni+1

endo



h=hnew

endp

