proc(hnew)=dib1step(hold,X,ker,k)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      densiterband, densestim

; -----------------------------------------------------------------

; Macro         dib1step

; -----------------------------------------------------------------

; Description   one step of iterative method in estimation

;               of optimal bandwidth for density estimate

; -----------------------------------------------------------------

; Usage        hnew = dib1step(hold,X,ker,k)

;  Input

;    Parameter  hold

;    Definition  scalar - previous iteration of optimal bandwidth

;    Parameter  X

;    Definition  n x 1 array - sample of random variable

;    Parameter  ker

;    Definition  string - kernel with support [-1,1]

;    Parameter  k

;    Definition  scalar - order of the kernel

;

;  Output

;    Parameter  hnew

;    Definition  scalar - new iteration of optimal bandwidth

; -----------------------------------------------------------------

; Example

; -----------------------------------------------------------------

; Result

; -----------------------------------------------------------------

; Keywords      density, kernel, bandwidth

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



;library("")
func("densestim.xpl")			; added for the absence of hazker library


n=rows(X)



minX=min(X)

maxX=max(X)

a=minX-2*hold

b=maxX+2*hold

; interval for integration in x-axes



nx=100

stepx=(b-a)/nx

xx=aseq(a,nx+1,stepx)

ny=100

stepy=2/ny

yy=aseq(-1,ny+1,stepy)

pxN=matrix(nx+1,1)

pxD=matrix(nx+1,1)

i=0

while(i<nx+1) ; composite trapezoidal rule in x direction

 i=i+1

 x=xx[i]

 py=x-hold*yy

 pyD=densestim(X,py,ker,hold).*_ker(yy)

 pyN=pyD.*_ker(yy)

 IyN=(sum(pyN[2:ny])+0.5*(pyN[1]+pyN[ny+1]))*stepy

 IyD=(sum(pyD[2:ny])+0.5*(pyD[1]+pyD[ny+1]))*stepy

 ; composite trapezoidal rule in y direction

 pxN[i]=IyN

 pxD[i]=(IyD-densestim(X,x,ker,hold))^2

endo

IN=(sum(pxN[2:nx])+0.5*(pxN[1]+pxN[nx+1]))*stepx

ID=(sum(pxD[2:nx])+0.5*(pxD[1]+pxD[nx+1]))*stepx



hnew=IN/(ID*2*n*k)



endp

