proc(Fn)=empiricaldistribution(x,v)

;; Library     smoother

; ---------------------------------------------------------------------

; See_also    kerneldistribution

; ---------------------------------------------------------------------

; Macro      empiricaldistribution

;-------------------------------------------------------------

;   Keywords  kernel smoothing, empirical distribution function 

;							estimation, nonparametric distribution estimation

; -----------------------------------------------------------------

;  Description  estimates a distribution function by empirical 

;								distribution function

; ----------------------------------------------------------

;  References    Sarda, P. and Vieu, P. (1989)

; ---------------------------------------------------------------------

; Usage       empiricaldistribution(x,datos)

; Input       

; Parameter   x

; Definition  n x 1 vector, the data. 

; Parameter   v

; Definition  p x 1 vector, the points where we estimate

;							the distribution function

;

; Output     Fn

;	Definition	p x 1 vector that contains the kernel distribution

;							function estimation 

; ---------------------------------------------------------------------

; Example     

;					n=100

;					x=normal(n)

;					

;					p=50

;					tmin=-2

;					tmax=2

;					s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

;					 						

;					F=cdfn2(s)   ;; distribution function of a N(0,1) 

;						

;					Fn=empiricaldistribution(x,s) ;; empirical distribution function

;					

;					z1= setmask(s~F,"line","black")

;					z2= setmask(s~Fn,"line","red")

;					plot(z1,z2)

; ---------------------------------------------------------------------

; Result  Generates 100 points of a standard normal distribution,

;					and plots the distribution function and the empirical

;					distribution function     

; ---------------------------------------------------------------------

; Author     G. Estvez-Prez and A. Quintela-del-Ro

; ---------------------------------------------------------------------



p=rows(v)

aux=matrix(p)



i=1

do

aux[i]=mean(x<=v[i])

i=i+1

until(i==(p+1))





Fn=aux





endp



