proc(resul)=epadistribution(x)

; ---------------------------------------------------------------------

; Library     smoother

; ---------------------------------------------------------------------

; See_also    epa

; ---------------------------------------------------------------------

; Macro       epadistribution

; ---------------------------------------------------------------------

; Description computes the integral of the epanechnikov kernel

;							applied to the estimation points x in the kernel 

;							distribution function estimation

; ---------------------------------------------------------------------

; Usage       result = epadistribution(x)

; Input       

; Parameter   x

; Definition  array

; Output      

; Parameter  resul

; Definition  array

; ---------------------------------------------------------------------

; Notes       

; ---------------------------------------------------------------------

; Example     

; ---------------------------------------------------------------------

; Result      

; ---------------------------------------------------------------------

; Keywords   kernel smoothing, kernel distribution function 

;							estimation, nonparametric distribution estimation

; ---------------------------------------------------------------------

; Reference   Sarda, P. and Vieu, P. (1991), Estvez and Quintela (1999), 

;		Estvez, Quintela and Vieu (2002)

; ---------------------------------------------------------------------

; Author      G. Estvez-Prez and A. Quintela del Ro

; ---------------------------------------------------------------------



n=rows(x)

result=matrix(n)



i=1

do

		if(x[i]<-1)

				result[i]=0

				else

				if((-1<=x[i])&& (x[i]<=1))

				result[i]=((1/2)+(3*x[i]/4)-((x[i]^3)/4))

				else

					result[i]=1

				endif

		endif

i=i+1

until(i==(n+1))

 resul=result

endp



