proc(dat)=grITTspd(ttree,ad,r,time)
; ---------------------------------------------------------------------
; Library     finance 
; ---------------------------------------------------------------------
; See_also    grITTcrr, grITTstsp, ITT, plotITT, regest
; ---------------------------------------------------------------------
; Macro       grITTspd
; ---------------------------------------------------------------------
; Description generates a state price density of an implied trinomial tree
; ---------------------------------------------------------------------
; Usage       dat=grITTspd(ttree,ad,r,time)
; Input       
; Parameter   ttree
; Definition  matrix; implied trinomial tree like the output of ITT(.)
; Parameter   ad
; Definition  matrix; Arrow-Debreu price like the output of ITT(.)
; Parameter   r
; Definition  scalar; interest rate, from interval (0,1)
; Parameter   time
; Definition  vector; time points corresponding to itree
; Output      
; Parameter   dat
; Definition  (n x 2) matrix; coordinates of the density curve
; ---------------------------------------------------------------------
; Notes       the state price density is estimated with the quantlet regest(.)
; ---------------------------------------------------------------------
; Example    
;    library("finance")
;    library("smoother")
;    library("graphic")
;
;    proc(sigma)=volafunc(S,K,time)	
;        sigma=0.15 + (S-K)/10 * 0.005 
;    endp
;
;    S = 100	        ; current index level
;    r = 0.1		; compounded riskless interest rate
;    div = 0.05         ; dividend yield
;    time = 0|1|3|6	; time vector
;
;    t=ITT(S, r, div, time, "volafunc")
;    
;    spd=grITTspd(t.Ttree,t.AD,r,time)
;    d=createdisplay(1,1)
;    show(d,1,1,spd)
; ---------------------------------------------------------------------
; Result      plot with points of the estimated density curve
; ---------------------------------------------------------------------
; Keywords    implied volatilities, Black Scholes model, option pricing
; ---------------------------------------------------------------------
; Reference   E. Derman, I. Kani and N. Chriss (1996): 
;             Implied Trinomial Trees of the Volatility Smile <br>
;             K. Komorad (2002): Implied Trinomial Trees and Their Implementation with XploRe
; ---------------------------------------------------------------------
; Link        www.gs.com/qs
; ---------------------------------------------------------------------
; Author      K. Komorad 20020319
; ---------------------------------------------------------------------
;
    error(sum(sort(time)!=time),"time must be increasing")
    tmp=time[2:rows(time)]-time[1:rows(time)-1]
    error(sum(tmp<=0),"time must be increasing")
    error(dim(ttree)!=dim(ad),"dim(ttree) <> dim(ad)")
    error((r<0)||(r>1),"r must be from (0,1)")
;    
    tau   = time[rows(time)]-time[1]	; duration of the tree
; prepare the data - AD prices were discounted
    data=ttree[,cols(ttree)]~(ad[,cols(ttree)]*exp(r*tau))
    dat=paf(data, data[,2]>0.0005)	; delete too small values
; estimate the curve
    mh=regest(data)
; delete NaN's    
    tmp = sum(mh==NaN,2)
    ind = (1:rows(mh)) .* (!tmp)
    error(sum(ind)==0,"there are too many NaN's in the estimated SPD")
    ind=paf(ind,ind!=0)
    mh=mh[ind,]
; standardize
    m=rows(mh)
    s=sum(mh[1:m-1,2].*(mh[2:m,1]-mh[1:m-1,1]))	
    dat=mh[,1]~mh[,2]./s
endp

