proc(Fh)=kerneldistribution(x,h,v)

; ---------------------------------------------------------------------

; Library     smoother

; ---------------------------------------------------------------------

; See_also    empiricaldistribution

; ---------------------------------------------------------------------

; Macro       kerneldistribution

;-------------------------------------------------------------

;   Keywords  kernel smoothing, kernel distribution function 

;							estimation, nonparametric distribution estimation

; -----------------------------------------------------------------

;  Description  estimates a distribution function by kernel 

;								distribution estimation

; ----------------------------------------------------------

;  References     Sarda, P. and Vieu, P. (1989), Estvez and Quintela (1999), 

;		Estvez, Quintela and Vieu (2002)

; ---------------------------------------------------------------------

; Usage       kerneldistribution(x,datos,h)

; Input       

; Parameter   x

; Definition  n x 1 vector, the data. 

; Parameter   h

;	Definition   scalar, bandwidth.

; Parameter   v

; Definition  p x 1 vector, the points where we estimate

;							the distribution function

;  

; Output     Fh

;	Definition	p x 1 vector that contains the kernel distribution

;							function estimation 

; ---------------------------------------------------------------------

; Example 

;        

;         n=100

;        x=normal(n)

;        

;        p=50

;        tmin=-2

;        tmax=2

;        s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

;         						

;        F=cdfn2(s)   ;; distribution function of a N(0,1) 

;        h=0.45	

;        Fn=kerneldistribution(x,h,s) ;; kernel distribution function

;        

;        z1= setmask(s~F,"line","black")

;        z2= setmask(s~Fn,"line","red")

;        plot(z1,z2)   

; ---------------------------------------------------------------------

; Result  Generates 100 points of a standard normal distribution,

;					and plots the distribution function and the kernel 

;					distribution function with bandwidth h     

; ---------------------------------------------------------------------

; Author     G. Estvez-Prez and A. Quintela-del-Ro

; ---------------------------------------------------------------------

p=rows(v)

aux=matrix(p)



t=1

do

aux[t]=mean(epadistribution((v[t]-x)/h))

t=t+1

until(t==(p+1))





Fh=aux





endp



