proc(rh)=kernelhazard(x,h,v)

; ---------------------------------------------------------------------

; Library     smoother

; ---------------------------------------------------------------------

; See_also    kernel density estimation, kernel distribution estimation

; ---------------------------------------------------------------------

; Macro       kernelhazard

;-------------------------------------------------------------

;   Keywords  kernel smoothing, kernel hazard estimation

; -----------------------------------------------------------------

;  Description  estimates a hazard function using the ratio of the

;								nonparametric density estimation and 1 minus the nonparametric

;								kernel distribution estimation

; ----------------------------------------------------------

;  References     Sarda, P. and Vieu, P. (1991), Estvez and Quintela (1999), 

;		Estvez, Quintela and Vieu (2002)

; ---------------------------------------------------------------------

; Usage       kernelhazard(x,h,v)

; Input       



; Parameter   x

; Definition  n x 1 vector, the data. 

; Parameter   h

;	Definition   scalar, bandwidth.

; Parameter   v

; Definition  p x 1 vector, the points where we estimate

;							the hazard function.

;  

; Output     rh

;	Definition	p x 1 vector that contains the kernel hazard

;							function estimation 

; ---------------------------------------------------------------------

; Example     

;		library("smoother")

;		 library("plot")

;		 library("hazard")

;		 n=100

;		  x=normal(n)

;		          

;					 

;		p=50

;		tmin=-2

;		tmax=2

;		s=tmin + (tmax-tmin)/(p-1).*(0:p-1) 

;		

;		fdis=cdfn2(s) ;; distribution function of a N(0,1)

;		 fden=pdfn2(s)	;; density function of  a N(0,1)

;		 

;		 r=fden/(1-fdis);  ;;theoretical hazard function

;		h=0.45

;		  rh=kernelhazard(x,h,s)

;		 z1= setmask(s~r,"line","black")

;		 z2= setmask(s~rh,"line","red")

;		 plot(z1,z2)

;		 tl="kernel hazard function estimation"

;		 xl="N(0,1)     "

;		 yl="hazard function    "

;		 setgopt(plotdisplay,1,1,"title",tl,"xlabel",xl,"ylabel",yl)

;					

; ---------------------------------------------------------------------

; Result     Computes the nonparametric hazard kernel estimate of a N(0,1) distribution,

;						and plots it with the teorethical hazard function

; ---------------------------------------------------------------------

; Author     G. Estvez-Prez and A. Quintela-del-Ro

; ---------------------------------------------------------------------

p=rows(v)

aux=matrix(p)



fh=denxest(x,h,"epa",v)

Fh=kerneldistribution(x,h,v)

aux=fh[,2]/(1-Fh)

rh=aux





endp



