proc(y) = optker02(x)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      optker02 optker04 optker06

;               optker13 optker15 optker17

;               optker24 optker26 optker28

; -----------------------------------------------------------------

; Macro         optker02

; -----------------------------------------------------------------

; Description   computes the optimal kernel of order 0,2

; -----------------------------------------------------------------

; Usage        y = optker02(x)

;  Input

;    Parameter  x

;    Definition  n x 1 array at which the kernel is to be computed

;  Output

;    Parameter  y

;    Definition  n x 1 array containing the optimal kernel of order 0.2

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           x = aseq(-1.5, 61, 0.05)

;           y = optker02(x)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The optimal kernel of order 0,2 is shown

; -----------------------------------------------------------------

; Keywords      optimal, kernel

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



  y = 0.75.*(1-x^2).*(abs(x).<1)

endp

