proc(y) = optker26(x)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      optker02 optker04 optker06

;               optker13 optker15 optker17

;               optker24 optker26 optker28

; -----------------------------------------------------------------

; Macro         optker26

; -----------------------------------------------------------------

; Description   computes the optimal kernel of order 2,6

; -----------------------------------------------------------------

; Usage        y = optker26(x)

;  Input

;    Parameter  x

;    Definition  n x 1 array at which the kernel is to be computed

;  Output

;    Parameter  y

;    Definition  n x 1 array containing the optimal kernel of order 2,6

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           x = aseq(-1.5, 61, 0.05)

;           y = optker26(x)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The optimal kernel of order 2,6 is shown

; -----------------------------------------------------------------

; Keywords      optimal, kernel

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



  y = (315/64).*(x^2-1).*(77.*x^4-58.*x^2+5).*(abs(x).<1)

endp

