proc(y) = optker28(x)

; -----------------------------------------------------------------

; Library       hazker

; -----------------------------------------------------------------

; See_also      optker02 optker04 optker06

;               optker13 optker15 optker17

;               optker24 optker26 optker28

; -----------------------------------------------------------------

; Macro         optker28

; -----------------------------------------------------------------

; Description   computes the optimal kernel of order 2,8

; -----------------------------------------------------------------

; Usage        y = optker28(x)

;  Input

;    Parameter  x

;    Definition  n x 1 array at which the kernel is to be computed

;  Output

;    Parameter  y

;    Definition  n x 1 array containing the optimal kernel of order 2,8

; -----------------------------------------------------------------

; Example   library("plot")

;           library("hazker")

;           x = aseq(-1.5, 61, 0.05)

;           y = optker28(x)

;           line(x~y)

; -----------------------------------------------------------------

; Result        The optimal kernel of order 2,8 is shown

; -----------------------------------------------------------------

; Keywords      optimal, kernel

; -----------------------------------------------------------------

; Reference

; -----------------------------------------------------------------

; Author        Ji Zelinka

; -----------------------------------------------------------------

;



  y = -(3465/2048).*(x^2-1).*(1755.*x^6-2249.*x^4+721.*x^2-35).*(abs(x).<1)

endp

