% Skript abb2punkt02 zur Darstellung der Grafik 2.2
%
% Aufruf:  abb2punkt02
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 27.6.2004


wuerfel = [6, 2, 3, 1, 6, 4, 6, 3, 2, 5, 4, 6, 2, 6, 1, 3, 3, 5, 4, 6 ...
           2, 6, 3, 1, 2, 3, 6, 3, 6, 4, 2, 4, 6, 5, 3, 5, 1, 4, 6, 2];

% Berechnung der relativen Hufigkeiten   

glsechs = (wuerfel==6);
absH = cumsum(glsechs);
anzahl = cumsum(ones(size(wuerfel)));

relH = absH./anzahl;
   
% grafische Darstellung

plot(anzahl,relH,'r-','LineWidth',4);

axis([1, anzahl(end), 0, 1])
xlabel('Wurfzahl', 'FontSize', 14)
ylabel('rel. Hufigkeit', 'FontSize', 14)
set(gca, 'FontSize', 14)

hold

% Plot der 0.28-Linie

x = (0:0.1:40); y = 0.28*ones(size(x));
plot(x,y,'b:','LineWidth',3);
text(40.5, 0.28, '0.28', 'FontSize', 14);


