% Skript abb2punkt23 zur Darstellung der Grafik 2.23
%
% Aufruf:  abb2punkt23
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 27.6.2004

p=0.2;  n=100;         % Koeffizienten der Binomialverteilung
k=(0:1:40);
bino = binopdfB(k,n,p);% Binomialverteilung
bar(k, bino)           % Histogrammdarstellung
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
axis([5,35,0,0.1])
set(gca, 'XTick', (10:5:30));
xtn = ['10'; '15'; '20'; '25'; '30'];
set(gca, 'XTickLabel', xtn)
hold

mu = n*p;             % Koeffizienten der Normalverteilung
sigma = sqrt(n*p*(1-p));
x=(0:0.01:40);        % Normalverteilung
normv = normpdfB(x,mu,sigma);
plot(x,normv,'r-','LineWidth',4);


xlabel('k,x', 'FontSize', 14);
ylabel('h_{0.2,100}(k) und N_{20,16}(x),', 'FontSize', 14);
set(gca, 'FontSize', 14)
