% Skript abb4punkt06 zur Darstellung der Grafik 4.6
%
% Aufruf:  abb4punkt06
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 9.9.2004


dx = 0.0001;                   % Diskretisierungsschrittweite
interv = (-0.5:dx:0.5);        % Intervalldiskretisierung
m1 = unifpdfB(interv,-0.15/2,+0.15/2);% Gleichvert. 0-zentriert
m3 = unifpdfB(interv,-0.3/2,+0.3/2);  % Gleichvert. 0-zentriert
m2 = triangpdf(interv,-0.05,+0.05);   % Dreieckvert. 0-zentriert

% Faltung der drei Verteilungsdichten (beachte:
% fr die Approximation des INTEGRALS muss mit der
% Diskretisierungsschrittweite multipliziert werden!

v1 = dx*conv(m1,m2);
verg = dx*conv(v1, m3);

% Berechnung des Vektors der Urbilder

N = (length(verg)-1)/2;
x = (-N*dx:dx:N*dx);

% Berechnung von Soll- und Mittelwert des Schliemaes

sollw = -5.8 + 2.8 + 3;
mw = -5.8+0.15/2 + 2.8+0.1+0.15 + 3;

% Verschiebung der Urbildwerte in den richtigen
% Wertebereich der Mae (des Schliemaes)

xSM = mw + x;

% Grafische Darstellung der Dichte des Schliemaes

plot(xSM,verg,'r-','LineWidth',5);
mx = max(verg);
axis([-N*dx+mw, N*dx+mw, 0, mx])

% Beschriftung des Plots

xlabel('M_s/mm', 'FontSize', 14);
ylabel('f(M_s)', 'FontSize', 14);
set(gca, 'FontSize', 14)






