% Skript abb7punkt05 zur Darstellung der Grafik 7.5
%
% Aufruf:  abb7punkt05
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.7.2004


T_u = 19.985; T_o = 20.075;
specs = [T_u, T_o];         % technische Toleranzgrenzen
Tm = (T_u+T_o)/2;           % Toleranzmitte
T = T_o-T_u;                % technischer Toleranzbereich

sigma = T/8;                % angenommene Prozesssteuung   
C_p = T/(6*sigma);          % Berechneter C_p-Wert dazu

mu = Tm;                    % Prozesslage ideal
                            % Grafische Darstellung
p1 = normspec(specs,mu,sigma);
ausschuss1 = 100*(1-p1);    % Ausschuss in Prozent

hC = get(gca,'Children');
set(hC(2), 'FaceColor', [0.50,0.50,0.50])
set(hC(1), 'LineWidth', 3)
set(hC(3), 'LineWidth', 3)
set(hC(4), 'LineWidth', 3)
                            % Deutsche Beschriftung
xlabel('Mae', 'FontSize', 14)
ylabel('Dichte der Normalverteilung', 'FontSize', 14)
title('')
set(gca, 'FontSize', 14)

                            % Illustration der Grenzen
yBereich = get(gca, 'YLim');
xBereich = [min(mu-6*sigma,T_u-0.01*T), max(mu+6*sigma,T_o+0.01*T)];
axis([xBereich(1), xBereich(2), yBereich(1), yBereich(2)])
h = line([T_u;T_u], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','r');
text(T_u+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_u', 'FontSize', 14); 
h = line([T_o;T_o], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','r');
text(T_o+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_o', 'FontSize', 14); 
h = line([Tm;Tm], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','g');
text(Tm+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_m', 'FontSize', 14); 


                            
mu = Tm+2*sigma;            % Prozesslage nicht ideal

                            % (normspec macht automatisch
                            % neues Grafikfenster auf)
                            % Grafische Darstellung
p2 = normspec(specs,mu,sigma);
ausschuss2 = 100*(1-p2);    % Ausschuss in Prozent

hC = get(gca,'Children');
set(hC(2), 'FaceColor', [0.50,0.50,0.50])
set(hC(1), 'LineWidth', 3)
set(hC(3), 'LineWidth', 3)
set(hC(4), 'LineWidth', 3)
set(hC(5), 'LineWidth', 3)
                            % Deutsche Beschriftung
xlabel('Mae', 'FontSize', 14)
ylabel('Dichte der Normalverteilung', 'FontSize', 14)
title('')
set(gca, 'FontSize', 14)

                            % Illustration der Grenzen
yBereich = get(gca, 'YLim');
axis([xBereich(1), xBereich(2), yBereich(1), yBereich(2)])
h = line([T_u;T_u], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','r');
text(T_u+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_u', 'FontSize', 14); 
h = line([T_o;T_o], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','r');
text(T_o+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_o', 'FontSize', 14); 
h = line([Tm;Tm], yBereich); set(h, 'LineWidth', 2);
set(h, 'Color','g');
text(Tm+0.01*(xBereich(2)-xBereich(1)), 0.95*yBereich(2), 'T_m', 'FontSize', 14); 


