% Skript abb8punkt15 zur Darstellung der Grafik 8.15
%
% Aufruf:  abb8punkt15
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.7.2004

% Stichprobe angeben

nvwerte = [  -0.4326   -1.6656    0.1253    0.2877   -1.1465 ...
              1.1909    1.1892   -0.0376    0.3273    0.1746 ...
             -0.1867    0.7258   -0.5883    2.1832   -0.1364 ...
              0.1139    1.0668    0.0593   -0.0956   -0.8323];
% Klassenmitten festsetzen

bins = [-4 -2 0 2 4];

% Absolute Klassenhufigkeiten mit hist bestimmen

[anz, x] = hist(nvwerte, bins);

% Relative Klassenhufigkeiten

relH = anz/length(nvwerte);

% Grafische Darstellung

breite = 2;     % Normierungsfaktor Klassenbreite
bar(x, relH/breite, 0.8);

% Anpassung der Grafik

hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])

hold
vals =(-4:0.01:4);
plot(vals, normpdfB(vals), 'r-', 'LineWidth',4);
axis([-4,4,0,0.45])
% Anpassung der Grafik

xlabel('Werte von X', 'FontSize', 14)
ylabel('rel. Klassenh./Dichte', 'FontSize', 14)
set(gca, 'FontSize', 14)
hold
