% Skript abb8punkt24 zur Darstellung der Grafik 8.24
%
% Aufruf:  abb8punkt24
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.7.2004



load verbrauch.dat
klmitten = (7.5:0.1:11.5);           % Klassenmitten
beta0 = [1/3, 8.5, 1/3, 10, 1/3];    % Startwert
[beta] = LsgAufgMModal(verbrauch, klmitten, beta0);

[Hfg, X, emdist, cemdist] = distempStetig(verbrauch, klmitten, 0);
bar(klmitten, emdist, 0.8);

hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])


set(gca, 'FontSize', 14);
xlabel('Werte von verbrauch.dat', 'FontSize', 14);
ylabel('rel. Hufigkeit / Dichte', 'FontSize', 14);
axis([7.5, 11.5, 0, 1.2])

lambda = beta(1); mu_1 = beta(2); sigma_1 = beta(3);
mu_2 = beta(4); sigma_2 = beta(5);

x = (7.5:0.01:11.5);
dnsity = lambda*normpdfB(x,mu_1,sigma_1)+...
              (1-lambda)*normpdfB(x,mu_2,sigma_2);

hold
plot(x, dnsity, 'r-', 'LineWidth',4)
hold