% Skript abb8punkt27 zur Darstellung der Grafik 8.27
%
% Aufruf:  abb8punkt27
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 6.7.2004


% Messwerte laden

load draehte.dat

% Parameter der Karte fr eine Vorlaufberechnung

alpha = 0.0027;               % Signifikanzniveau
conf = 1-alpha;
                              % technische Toleranzen
                              % laut Vorgabe
Tolgrenzen = [0.56-0.006, 0.56+0.006];        
                              % Schtzverfahren fr
                              % die Streuung einstellen
verfahren = 'std';

% Berechnung der Mittelwertkarte

[outliersX, avg, s, UEGX, OEGX] ...
             = xbarplotD(draehte,conf,Tolgrenzen,verfahren);
         
xlabel('Stichproben', 'FontSize', 14)
ylabel('Messungen', 'FontSize', 14)
set(gca, 'FontSize', 14);

chlds = get(gca, 'Children');

for k=3:7
    set(chlds(k), 'FontSize', 14);
end;
for k=8:length(chlds)
    set(chlds(k), 'LineWidth', 3);
end;
for k=1:2
    set(chlds(k), 'LineWidth', 3);
end;
         
% Berechnung der Streuungskarte

figure
[outliersS, sbar, UEGS, OEGS] = schartD(draehte,conf);

xlabel('Stichproben', 'FontSize', 14)
ylabel('Messungen', 'FontSize', 14)
set(gca, 'FontSize', 14);

set(gca, 'FontSize', 14)

chlds = get(gca, 'Children');

for k=4:9
    set(chlds(k), 'LineWidth', 3);
end;

for k=1:3
    set(chlds(k), 'FontSize', 14);
end;