function [Arg]= AngKomplex(cmplxNum)
%
% Funktion AngKomplex
%
% Aufruf:  [ArgGrad]= AngKomplex(cmplxNum)
%
%
% Berechnet das Argument der in algebraischer Darstellung 
% bergebenen komplexen Zahl cmplxNum.
%
% Eingabeparameter:    cmplxNum    Zahl (komplex)
%
% Ausgabeparameter:    Arg         Argument von cmplxNum
%                      
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 23.08.2004


% Real- und Imaginrteil berechnen

cmplxNumRT = real(cmplxNum);
cmplxNumIm = imag(cmplxNum);

% Quadrant feststellen

if cmplxNumRT > 0
      Arg = atan(cmplxNumIm/cmplxNumRT);
elseif cmplxNumRT < 0       % zweiter und dritter Quadrant!
   if cmplxNumIm >= 0       % zweiter Quadrant!
      Arg = atan(cmplxNumIm/cmplxNumRT)+ pi;
   else                     % dritter Quadrant!
      Arg = atan(cmplxNumIm/cmplxNumRT) - pi;
   end
else                        % Sonderfall: Realteil = 0
   if cmplxNumIm >= 0       % Imaginrteil positiv
      Arg = pi/2;
   else                     % Imaginrteil negativ
      Arg = 3*pi/2;
   end;
end;
   

       
     