% Skript-File AufgChi2test2.m
%
% Aufruf:  AufgChi2test2
%
% Script-File zur Durchfhrung eines Chi-Quadrat-Tests fr Wrfeldaten.
%
% Die Wurfsequenz wuerfel muss im File editiert werden.
% Das Testergebnis (0,1) wird in TestErg abgelegt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003



wuerfel = [6, 2, 3, 1, 6, 4, 6, 3, 2, 5, 4, 6, 2, 6, 1, 3, 3, 5, 4, 6 ...
           2, 6, 3, 1, 2, 3, 6, 3, 6, 4, 2, 4, 6, 5, 3, 5, 1, 4, 6, 2];

% Absolute empirische Hufigkeiten 

[hfg, X] = hist(wuerfel, (1:1:6));
   

alpha = 0.01;                        % Signifikanzniveau
K = length(hfg)                      % Zahl der "Klassen"

% Vektor der theoretischen absoluten Hufigkeiten fr einen fairen Wrfel

thfg = ones(size(hfg))*sum(hfg)/K;   

% Bestimmung des kritischen Werts

c = chi2invB(1-alpha, K-1)

% Berechnung der Testvariablen

chi2 = sum(((hfg-thfg).^2)./hfg)

% Ergebnis des Tests

TestErg = ~(chi2<=c)