% Script-File AufgClinton.m
%
% Aufruf:  AufgClinton
%
% Schtzung der Parameter einer Lognormal-verteilten Gre anhand
% einer Inauguralrede von US-Prsident Bill Clinton (clinton.txt)
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 27.6.2004

% Auswertung der Inauguralrede (Wortlngen)

[anz, lngabs, lngrel, wlngen]= txtstat('clinton.txt');

EW = mean(wlngen);            % Empirischer Mittelwert und
VAR = var(wlngen);            % empirische Varianz der Wortlngen

% Histogrammdarstellung

bar(lngrel(1,:), lngrel(2,:))
set(gca, 'FontSize', 14)
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
hold

% Schtzung der Parameter nach der Momentenmethode

mu = log(EW^2/(VAR+EW^2)^(1/2))
sigma = 2^(1/2)*log((VAR+EW^2)^(1/2)/EW)^(1/2)

x=(0:0.1:15);
lognd = lognpdfB(x, mu, sigma);
plot(x, lognd, 'r-', 'LineWidth', 4);

% Schtzung der Parameter nach der Momentenmethode
% (alternative Schtzung)

M = median(wlngen)
mu = log(M);
sigma = sqrt(2*(log(EW)-mu));
lognd = lognpdfB(x, mu, sigma);
plot(x, lognd, 'g-', 'LineWidth', 4);

set(gca, 'FontSize', 14);
xlabel('Werte von X', 'FontSize', 14);
ylabel('Rel. Klassenh./Dichte', 'FontSize', 14);




