function [vals] = AufgMModalfun(beta, x, klmitten)
%
% Aufruf:  [vals] = AufgMModalfun(beta, x, klmitten)
%
% Beispielaufruf: [vals] = AufgMModalfun([1/3, 8.5, 1/3, 10, 1/3]', 8.0, (7.5:0.1:11.5)')
%
% Funktion zur Berechnung der theoretischen Klassenhufigkeiten
% einer Mischverteilung zweier Normalverteilungen mit den Parametern 
% lambda, mu_1, mu_2, sigma_1, sigma_2 fr die Klassenmitten aus klmitten
%
% Eingangsdaten:	  klmitten   gewhlte Klassenmitten
%                     x          eine dieser Klassenmitten
%                     beta       Parametervektor
%
% Ausgangsdaten:	  vals       theoretische Klassenhufigkeiten
%                                der Mischverteilung
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 26.12.2003/14.9.2004

% Parameter der Mischverteilung

lambda = beta(1); mu_1 = beta(2); sigma_1 = beta(3);
mu_2 = beta(4); sigma_2 = beta(5);

% Klassengrenzen aus den Klassenmitten berechnen

dxs = diff(klmitten)/2;
klsgrnz = klmitten(1:end-1)+dxs;
klsgrnz = klsgrnz(:);       % Spaltenvektor
klsgrnz = [-Inf; klsgrnz; Inf];

indx = find(x==klmitten);
grz = [klsgrnz(indx), klsgrnz(indx+1)];
% Theoretische Klassenhufigkeit berechnen

vals = lambda*(normcdfB(grz(2), mu_1, sigma_1)-...
             normcdf(grz(1), mu_1, sigma_1))...
       + (1-lambda)*(normcdfB(grz(2), mu_2, sigma_2)-...
                   normcdf(grz(1), mu_2, sigma_2));