% Skript-File Aufruf_MCFlaeche
%
%
% Aufruf:  Aufruf_MCFlaeche
%
% Mit diesem Skript-File kann ein Polygonzug mit Hilfe von polyput
% gezeichnet werden. Anschlieend wird die Flche des Polygons mit Hilfe der
% MONTE-CARLO-METHODE berechnet und ggf. grafisch dargestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.03.2003


% Vorinitialisierungen  (hier editieren)

a = 1;                   % Parameter des Rechtecks
b = 1;
N = 1000;                % MC-Parameter
pz = 1;                  % MC-Punkte zeichnen ja (1) oder nein (0)


% Modul fr Polygonerstellung aufrufen

[polygon, axhndl] = polyput(a,b);
drawnow;

% Modul fr die Flchenberechnung aufrufen

[F, MCPoints] = MCFlaeche(a,b,polygon,N);

% MC-Punkte zeichnen, falls gewnscht

hold on
if pz
    for j=1:length(MCPoints)
        if MCPoints(j,3)
            plot(MCPoints(j,1),MCPoints(j,2),'ro');
        else
            plot(MCPoints(j,1),MCPoints(j,2),'go');
        end;
    end;
end;

title('Flchenschtzung mit MONTE-CARLO-Methode');
text(a/2,b/2, ['Flche:  ', num2str(F)], 'FontSize', 12, 'FontWeight', 'bold');

    


