% Skript-File Aufruf_getExpVar
%
%
% Aufruf:  Aufruf_getExpVar
%
% Mit diesem Skript-File kann die Funktion getExpVar zur Erzeugung 
% exponentiell verteilter Zufallszahlen parametriert werden.
% Ferner wird das Ergebnis in Form eines Histogramms und einer Kurve
% der theoretischen Verteilungsdichte dargestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.03.2003


% Vorinitialisierungen  (hier editieren)

N = 2000;              % Anzahl der Zufallszahlen
lambda = 2;            % Parameter der Exponentialverteilung


% Modul fr die Erstellung der Zufallszahlen aufrufen

ExpZahlen = getExpVar(lambda, N);


% Darstellung des Ergebnisses in Form eines Histogramms

                         % grter Wert zur festlegung des Darstellungsbereichs
mBereich = max(ExpZahlen); 
                         % Bestimmung der Klassenanzahl und der Klassenmitten
KlAnz = max(5, floor(sqrt(N)));
KlAnz = min(KlAnz, 50);
dx = mBereich/KlAnz;
bins = (dx/2:dx:KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
[M, X, emdist, cemdist] = distemp3(ExpZahlen, bins, 0);

                         % Plot des Histogramms
bar(X, emdist, 0.8);
set(gca, 'FontSize', 14);
xlabel('x', 'FontSize', 14);
ylabel('Rel. Klassenh.', 'FontSize', 14);
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])

hold on

                          % Plot der theoretischen Verteilung
pts = (0:0.001:bins(end));
ExpV = lambda*exp(-lambda*pts);
plot(pts, ExpV, 'r', 'LineWidth',4);
axis([0, bins(end), 0, max(max(emdist),max(ExpV))]);




%title(['Zufallszahlenhistogramm fr Parameter lambda = ', num2str(lambda)]);
text(bins(end)/4, lambda*exp(-lambda*bins(end)/4), ['Theoretische Verteilung'], 'FontSize', 14, 'FontWeight', 'bold');

    


