% Skript-File Aufruf_getFBspVar
%
%
% Aufruf:  Aufruf_getFBspVar
%
% Mit diesem Skript-File kann die Funktion Aufruf_getFBspVar zur Erzeugung 
% von Zufallszahlen parametriert werden, die eine vorgegenene Verteilungsfunktion
% haben (Sie muss im Quelltext dieses Skripts angegeben werden).
% Ferner wird das Ergebnis in Form eines Histogramms zusammen mit der
% theoretischen Verteilungsdichte dargestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


% Vorinitialisierungen  (hier editieren)

N = 20000;                   % Anzahl der Zufallszahlen
Fvert = @FBspVertFkt;        % handle auf die Verteilungsfunktion


% Modul fr die Erstellung der Zufallszahlen aufrufen

[ZZahlen] = getFBspVar(Fvert, N);

% Darstellung des Ergebnisses in Form eines Histogramms

                         % grter Wert zur festlegung des Darstellungsbereichs
mBereich = max(ZZahlen); 
                         % Bestimmung der Klassenanzahl und der Klassenmitten
KlAnz = max(5, floor(sqrt(N)));
KlAnz = min(KlAnz, 50);
dx = mBereich/KlAnz;
bins = (dx/2:dx:KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
[M, X, emdist, cemdist] = distempStetig(ZZahlen, bins, 0);

                         % Plot des Histogramms
bar(X, emdist, 0.8);
set(gca, 'FontSize', 11);
xlabel('Werte von Y');
ylabel('Rel. Klassenh. und Dichte');

hold on

                          % Plot der theoretischen Verteilung
pts = (0:0.001:bins(end)+dx);
                          % Werte der Verteilungsfunktion
VertFkt = feval(Fvert, pts);
                          % Numerische Ableitung (Dichte)
thVertD = 1000*[diff(VertFkt),0];
plot(pts, thVertD, 'r', 'LineWidth',4);
axis([0, bins(end)+dx, 0, max(max(emdist),max(thVertD))]);


%title(['Zufallszahlenhistogramm fr die vorgegebene Verteilungsdichte']);


    


