% Skript-File Aufruf_getPoissVar
%
%
% Aufruf:  Aufruf_getPoissVar
%
% Mit diesem Skript-File kann die Funktion getPoissVar zur Erzeugung 
% Poisson-verteilter Zufallszahlen parametriert werden.
% Ferner wird das Ergebnis in Form eines Histogramms und eines 
% Stabdiagramms der theoretischen Verteilungsdichte dargestellt.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


% Vorinitialisierungen  (hier editieren)

N = 2000;                 % Anzahl der Zufallszahlen
mu = 3;                   % Parameter der Exponentialverteilung


% Modul fr die Erstellung der Zufallszahlen aufrufen

PoissZahlen = getPoissVar(mu, N);

% Darstellung des Ergebnisses in Form eines Histogramms

                         % grter Wert zur festlegung des Darstellungsbereichs
KlAnz = max(PoissZahlen)+1; 
                         % Bestimmung der Klassenanzahl und der Klassenmitten
dx = 1;
bins = (0:dx:KlAnz-1);

                         % Berechnung der Histogrammbalken
[M, X, emdist, cemdist] = distemp3(PoissZahlen, bins, 0);

                         % Plot des Histogramms
bar(X, emdist, 0.8);
set(gca, 'FontSize', 11);
xlabel('Werte von Y');
ylabel('Rel. Hufigkeit.');

hold on

                          % Plot der theoretischen Verteilung
ExpP = poisspdfB(bins, mu);
hndl = stem(bins, ExpP, 'r');
set(hndl, 'LineWidth',3);
axis([0, bins(end), 0, max(max(emdist),max(ExpP))]);


%title(['Zufallszahlenhistogramm fr Parameter mu = ', num2str(mu)]);
text(floor(bins(end)/2), poisspdfB(floor(bins(end)/2), mu), ['Theoretische Verteilung'], 'FontSize', 12, 'FontWeight', 'bold');

    


