% Skript-File Aufruf_triangVar
%
%
% Aufruf:  Aufruf_triangVar
%
% Mit diesem Skript-File kann die Funktion triangrnd zur Erzeugung 
% dreiecksverteilter Zufallszahlen parametriert werden.
% Ferner wird das Ergebnis in Form eines Histogramms und einer Kurve
% der theoretischen Verteilungsdichte dargestellt.
%
% Der Quelltext muss dafr editiert werden!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 21.03.2003


% Vorinitialisierungen  (hier editieren)

N = 10000;             % Anzahl der Zufallszahlen
a = 0; 
b = 2;                 % Parameter der Dreiecksverteilung

% Modul fr die Erstellung der Zufallszahlen aufrufen

TriangZahlen = triangrnd(N, a, b);


% Darstellung des Ergebnisses in Form eines Histogramms

                         % grter Wert zur Festlegung des Darstellungsbereichs
mBereich = max(TriangZahlen); 
                         % Bestimmung der Klassenanzahl und der Klassenmitten
KlAnz = max(5, floor(sqrt(N)));
KlAnz = min(KlAnz, 50);
dx = mBereich/KlAnz;
bins = (dx/2:dx:KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
[M, X, emdist, cemdist] = distemp3(TriangZahlen, bins, 0);

                         % Plot des Histogramms
bar(X, emdist, 0.8);
set(gca, 'FontSize', 11);
xlabel('Werte von X');
ylabel('Dichte');

hold on

                          % Plot der theoretischen Verteilung
pts = (0:0.001:bins(end));
TiangV = triangpdf(pts,a,b);
plot(pts, TiangV, 'r', 'LineWidth',3);
axis([0, bins(end), 0, max(max(emdist),max(TiangV))]);




title(['Zufallszahlenhistogramm die Dreiecksverteilung']);
text(bins(end)/4, triangpdf(bins(end)/4,a,b), ['Theoretische Verteilung'], 'FontSize', 12, 'FontWeight', 'bold');

    


