% Script-File BspEmpWurf.m
%
% Aufruf:  BspEmpWurf
%
% bungsaufgabe zum Parametertest fr eine Binomialverteilung
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 10.7.2002

wuerfel = [6, 2, 3, 1, 6, 4, 6, 3, 2, 5, 4, 6, 2, 6, 1, 3, 3, 5, 4, 6 ...
           2, 6, 3, 1, 2, 3, 6, 3, 6, 4, 2, 4, 6, 5, 3, 5, 1, 4, 6, 2];
   

% Testparameter

alpha = 0.05;          % Signifikanzniveau
n = length(wuerfel);   % Stichprobenlnge
p0 = 0.28;             % Nullhypothese H0

% Kritischer Wert fr den zweiseitigen Test

c = ( binoinv(1-alpha/2, n, p0) - binoinv(alpha/2, n, p0) )/(2*n)

% Testergebnis (0 = H0 wird angenommen, 1 = H0 wird abgelehnt)

TestErg = ~((p_0-c <= mean(wuerfel==6))&(mean(wuerfel==6) <= p_0+c))